/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.pascal;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.storage.filters.PascalTextFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.storage.os.pascal.PascalFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.ByteArrayOutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class PascalFileEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    private byte[] fileEntry;
    private PascalFormatDisk disk;
    private int index = 0;
    private boolean deleted = false;

    public PascalFileEntry(byte[] fileEntry, PascalFormatDisk disk) {
        this.fileEntry = fileEntry;
        this.disk = disk;
    }

    public int getFirstBlock() {
        return AppleUtil.getWordValue(this.fileEntry, 0);
    }

    public void setFirstBlock(int first) {
        AppleUtil.setWordValue(this.fileEntry, 0, first);
    }

    public int getLastBlock() {
        return AppleUtil.getWordValue(this.fileEntry, 2);
    }

    public void setLastBlock(int last) {
        AppleUtil.setWordValue(this.fileEntry, 2, last);
    }

    @Override
    public String getFilename() {
        return AppleUtil.getPascalString(this.fileEntry, 6);
    }

    @Override
    public void setFilename(String filename) {
        AppleUtil.setPascalString(this.fileEntry, 6, filename.toUpperCase(), 15);
    }

    @Override
    public int getMaximumFilenameLength() {
        return 15;
    }

    @Override
    public String getFiletype() {
        String[] filetypes = this.disk.getFiletypes();
        int filetype = this.fileEntry[4] & 0xF;
        if (filetype == 0 || filetype > filetypes.length) {
            return this.textBundle.format("PascalFileEntry.UnknownFiletype", filetype);
        }
        return filetypes[filetype - 1];
    }

    @Override
    public void setFiletype(String filetype) {
        if ("bad".equalsIgnoreCase(filetype)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 1);
        } else if ("code".equalsIgnoreCase(filetype)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 2);
        } else if ("text".equalsIgnoreCase(filetype)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 3);
        } else if ("info".equalsIgnoreCase(filetype)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 4);
        } else if ("data".equalsIgnoreCase(filetype)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 5);
        } else if ("graf".equalsIgnoreCase(filetype)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 6);
        } else if ("foto".equalsIgnoreCase(filetype)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 7);
        } else {
            AppleUtil.setWordValue(this.fileEntry, 4, 0);
        }
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setLocked(boolean lock) {
    }

    public int getBytesUsedInLastBlock() {
        return AppleUtil.getWordValue(this.fileEntry, 22);
    }

    public void setBytesUsedInLastBlock(int value) {
        AppleUtil.setWordValue(this.fileEntry, 22, value);
    }

    @Override
    public int getSize() {
        int blocks = this.getBlocksUsed() - 1;
        return blocks * 512 + this.getBytesUsedInLastBlock();
    }

    public int getBlocksUsed() {
        return AppleUtil.getWordValue(this.fileEntry, 2) - AppleUtil.getWordValue(this.fileEntry, 0);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    public List<PascalFileEntry> getFiles() {
        return null;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void delete() {
        int index = 0;
        String dname = this.getFilename();
        List<PascalFileEntry> dir = this.disk.getDirectory();
        int count = dir.size();
        for (int i = 1; i < count; ++i) {
            String fname = dir.get(i).getFilename();
            if (!dname.equals(fname)) continue;
            index = i;
        }
        if (index != 0) {
            dir.remove(index);
            PascalFileEntry volEntry = dir.get(0);
            volEntry.setFileCount(count - 2);
            dir.set(0, volEntry);
            this.disk.putDirectory(dir);
            this.deleted = true;
        }
    }

    public Date getModificationDate() {
        return AppleUtil.getPascalDate(this.fileEntry, 24);
    }

    public void setModificationDate(Date date) {
        AppleUtil.setPascalDate(this.fileEntry, 24, date);
    }

    @Override
    public List<String> getFileColumnData(int displayMode) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.textBundle.get("PascalFileEntry.PascalDateFormat"));
        ArrayList<String> list = new ArrayList<String>();
        switch (displayMode) {
            case 2: {
                list.add(dateFormat.format(this.getModificationDate()));
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getBlocksUsed()));
                list.add(this.getFiletype());
                list.add(this.getFilename());
                break;
            }
            case 3: {
                list.add(dateFormat.format(this.getModificationDate()));
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getBlocksUsed()));
                numberFormat.setMinimumIntegerDigits(1);
                list.add(numberFormat.format(this.getBytesUsedInLastBlock()));
                list.add(numberFormat.format(this.getSize()));
                list.add(this.getFiletype());
                list.add(this.getFilename());
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getFirstBlock()));
                list.add(numberFormat.format(this.getLastBlock() - 1));
                break;
            }
            default: {
                list.add(this.getFilename());
                list.add(this.getFiletype());
                list.add(numberFormat.format(this.getSize()));
                list.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return list;
    }

    @Override
    public byte[] getFileData() {
        return this.disk.getFileData(this);
    }

    private byte[] filterText(byte[] data) {
        int LF = 10;
        int CR = 13;
        int DLE = 16;
        int SP = 32;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(data.length);
        int index = 0;
        while (index < data.length) {
            byte b = data[index];
            if (b == 13 || b == 10) {
                buf.write(13);
                if (b == 13 && ++index < data.length && data[index] == 10) {
                    ++index;
                }
                int spaceCount = 32;
                while (index < data.length && data[index] == 32) {
                    spaceCount = (byte)(spaceCount + 1);
                    ++index;
                }
                if (spaceCount <= 32) continue;
                buf.write(16);
                buf.write(spaceCount);
                continue;
            }
            buf.write(b);
            ++index;
        }
        return buf.toByteArray();
    }

    private void storageError(String s) throws DiskFullException {
        if (this.index > 0) {
            List<PascalFileEntry> dir = this.disk.getDirectory();
            int count = dir.size();
            dir.remove(this.index);
            PascalFileEntry volEntry = dir.get(0);
            volEntry.setFileCount(count - 2);
            dir.set(0, volEntry);
            this.disk.putDirectory(dir);
            throw new DiskFullException(s, this.disk.getFilename());
        }
    }

    private int findEOL(byte[] data, int offset) throws DiskFullException {
        for (int i = offset + 1022; i > offset; --i) {
            if (data[i] != 13) continue;
            return i;
        }
        this.storageError(this.textBundle.get("PascalFileEntry.LineLengthError"));
        return 0;
    }

    @Override
    public void setFileData(byte[] data) throws DiskFullException {
        int first = this.getFirstBlock();
        int last = this.getLastBlock();
        if (this.fileEntry[4] == 3) {
            data = this.filterText(data);
            byte[] buf1 = new byte[512];
            byte[] buf2 = new byte[512];
            int offset = 0;
            int pages = 0;
            this.disk.writeBlock(first, buf1);
            this.disk.writeBlock(first + 1, buf2);
            ++pages;
            while (offset + 1023 < data.length) {
                if (pages * 2 > last - first - 2) {
                    this.storageError(this.textBundle.get("PascalFileEntry.NotEnoughRoom"));
                }
                int crPtr = this.findEOL(data, offset);
                System.arraycopy(data, offset, buf1, 0, 512);
                System.arraycopy(data, offset + 512, buf2, 0, crPtr - offset + 1 - 512);
                this.disk.writeBlock(first + pages * 2, buf1);
                this.disk.writeBlock(first + pages * 2 + 1, buf2);
                ++pages;
                Arrays.fill(buf1, (byte)0);
                Arrays.fill(buf2, (byte)0);
                offset = crPtr + 1;
            }
            if (offset < data.length) {
                int len1 = data.length - offset;
                int len2 = 0;
                if (len1 > 512) {
                    len2 = len1 - 512;
                    len1 = 512;
                }
                System.arraycopy(data, offset, buf1, 0, len1);
                this.disk.writeBlock(first + pages * 2, buf1);
                if (len2 > 0) {
                    System.arraycopy(data, offset + 512, buf2, 0, len2);
                    this.disk.writeBlock(first + pages * 2 + 1, buf2);
                    this.setBytesUsedInLastBlock(len2);
                    this.setLastBlock(first + pages * 2 + 2);
                } else {
                    this.setBytesUsedInLastBlock(len1);
                    this.setLastBlock(first + pages * 2 + 1);
                }
            } else {
                this.setLastBlock(first + pages * 2);
                this.setBytesUsedInLastBlock(512);
            }
        } else {
            if (data.length > (last - first) * 512) {
                this.storageError(this.textBundle.get("PascalFileEntry.NotEnoughRoom"));
            }
            byte[] buf = new byte[512];
            int blocks = data.length / 512;
            int bytes = data.length % 512;
            for (int i = 0; i < blocks; ++i) {
                System.arraycopy(data, i * 512, buf, 0, 512);
                this.disk.writeBlock(first + i, buf);
            }
            if (bytes > 0) {
                Arrays.fill(buf, (byte)0);
                System.arraycopy(data, blocks * 512, buf, 0, bytes);
                this.disk.writeBlock(first + blocks, buf);
                this.setLastBlock(first + blocks + 1);
                this.setBytesUsedInLastBlock(bytes);
            } else {
                this.setLastBlock(first + blocks);
                this.setBytesUsedInLastBlock(512);
            }
        }
        if (this.index > 0) {
            List<PascalFileEntry> dir = this.disk.getDirectory();
            dir.set(this.index, this);
            this.disk.putDirectory(dir);
        }
    }

    @Override
    public FileFilter getSuggestedFilter() {
        if ("TEXT".equals(this.getFiletype())) {
            if (this.getFilename().toLowerCase().endsWith(".text")) {
                return new PascalTextFileFilter();
            }
            return new TextFileFilter();
        }
        if ("DATA".equals(this.getFiletype()) && this.getSize() >= 8184 && this.getSize() <= 8192) {
            GraphicsFileFilter filter = new GraphicsFileFilter();
            filter.setMode(2);
            return filter;
        }
        return new BinaryFileFilter();
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }

    public byte[] toBytes() {
        return this.fileEntry;
    }

    @Override
    public boolean needsAddress() {
        return false;
    }

    @Override
    public void setAddress(int address) {
    }

    @Override
    public boolean canCompile() {
        return false;
    }

    public void setEntryIndex(int index) {
        this.index = index;
    }

    public void setFileCount(int count) {
        AppleUtil.setWordValue(this.fileEntry, 16, count);
    }
}

